/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CThread.h,v 1.3 1999/09/20 01:27:06 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CThread_h	// [
#define Included_CThread_h

#include "pgpClassesConfig.h"
#include "CPFLImpFactory.h"

_PGP_BEGIN

// Class CThread

class CThread SMART_ERROR_INHERIT
{
	NOT_COPYABLE(CThread)
	DECLARE_IMPHOST(CThread)

public:
	enum {kDefaultMaxQRequests = 10};
	typedef void (_cdecl * CallbackFunc)(void *refPtr);

public:
	PGPBoolean	IsRunning() const;

	SMART_ERROR	StartThread(PGPUInt32 maxQueuedRequests = 
		kDefaultMaxQRequests);
	void		KillThread();

	SMART_ERROR	PerformAsyncCallback(CallbackFunc callbackFunc, 
		void *refPtr = NULL);
	SMART_ERROR	PerformSyncCallback(CallbackFunc callbackFunc, 
		void *refPtr = NULL);
};

_PGP_END

#endif	// ] Included_CThread_h
